/*
 * Decompiled with CFR 0.152.
 */
package com.leospa.clients;

import com.leospa.properties.ConfigPropertiesFile;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class SerialClient {
    public static String TalkRFID(String portName, String hexStringTx, int Timeout) {
        block19: {
            String str = "";
            try {
                CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(portName);
                SerialPort serialPort = (SerialPort)portId.open("Demo application", 5000);
                serialPort.setSerialPortParams(9600, 8, 1, 0);
                OutputStream outputStream = serialPort.getOutputStream();
                InputStream inputStream = serialPort.getInputStream();
                byte[] tx = SerialClient.hexStringToCharArray(hexStringTx);
                outputStream.write(tx);
                boolean dataValid = false;
                int msCount = 0;
                byte[] bufferRead = new byte[100];
                int byteindex = 0;
                while (Timeout-- > 0) {
                    if (inputStream.available() > 0) {
                        byte b;
                        bufferRead[byteindex] = b = (byte)inputStream.read();
                        ++byteindex;
                        msCount = 0;
                    }
                    Thread.sleep(1L);
                    if (++msCount > 50) {
                        msCount = 0;
                        dataValid = true;
                    }
                    if (!dataValid) continue;
                    if (byteindex > 0) {
                        String hexString = "";
                        int i = 0;
                        while (i < byteindex) {
                            String hex = Integer.toHexString(bufferRead[i]);
                            if (hex.length() < 2) {
                                hex = "0" + hex;
                            } else if (hex.length() > 2) {
                                hex = hex.substring(hex.length() - 2);
                            }
                            if (i < byteindex - 1) {
                                hex = String.valueOf(hex) + " ";
                            }
                            hexString = String.valueOf(hexString) + hex;
                            ++i;
                        }
                        str = hexString;
                        break;
                    }
                    byteindex = 0;
                    msCount = 0;
                    dataValid = false;
                }
                inputStream.close();
                outputStream.close();
                serialPort.close();
                return str;
            }
            catch (NoSuchPortException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("No such port as specified in Config.txt, portName: " + portName);
                }
            }
            catch (PortInUseException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Port " + portName + " is \"In Use\"");
                }
            }
            catch (IOException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    e.printStackTrace();
                }
            }
            catch (InterruptedException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedCommOperationException e) {
                if (!ConfigPropertiesFile.DEBUG_MODE_ON) break block19;
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String TalkRelay(String portName, String hexStringTx, int Timeout) {
        block19: {
            System.out.println("PortName: " + portName + ", HexStringTx: " + hexStringTx + ", Timeout: " + Timeout);
            String str = "";
            try {
                CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(portName);
                SerialPort serialPort = (SerialPort)portId.open("Demo application", 5000);
                serialPort.setSerialPortParams(38400, 8, 1, 0);
                OutputStream outputStream = serialPort.getOutputStream();
                InputStream inputStream = serialPort.getInputStream();
                byte[] tx = SerialClient.hexStringToCharArray(hexStringTx);
                outputStream.write(tx);
                boolean dataValid = false;
                int msCount = 0;
                byte[] bufferRead = new byte[100];
                int byteindex = 0;
                while (Timeout-- > 0) {
                    if (inputStream.available() > 0) {
                        byte b;
                        bufferRead[byteindex] = b = (byte)inputStream.read();
                        ++byteindex;
                        msCount = 0;
                    }
                    Thread.sleep(1L);
                    if (++msCount > 50) {
                        msCount = 0;
                        dataValid = true;
                    }
                    if (!dataValid) continue;
                    if (byteindex > 0) {
                        String hexString = "";
                        int i = 0;
                        while (i < byteindex) {
                            String hex = Integer.toHexString(bufferRead[i]);
                            if (hex.length() < 2) {
                                hex = "0" + hex;
                            } else if (hex.length() > 2) {
                                hex = hex.substring(hex.length() - 2);
                            }
                            if (i < byteindex - 1) {
                                hex = String.valueOf(hex) + " ";
                            }
                            hexString = String.valueOf(hexString) + hex;
                            ++i;
                        }
                        str = hexString;
                        break;
                    }
                    byteindex = 0;
                    msCount = 0;
                    dataValid = false;
                }
                inputStream.close();
                outputStream.close();
                serialPort.close();
                System.out.println("=============================Status: " + str);
                return str;
            }
            catch (NoSuchPortException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("No such port as specified in Config.txt, portName: " + portName);
                }
            }
            catch (PortInUseException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Port " + portName + " is \"In Use\"");
                }
            }
            catch (IOException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    e.printStackTrace();
                }
            }
            catch (InterruptedException e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedCommOperationException e) {
                if (!ConfigPropertiesFile.DEBUG_MODE_ON) break block19;
                e.printStackTrace();
            }
        }
        return "";
    }

    private static int hexToInt(char ch) {
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        throw new IllegalArgumentException(String.valueOf(ch));
    }

    static String hexToAscii(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n / 2);
        int i = 0;
        while (i < n) {
            char a = s.charAt(i);
            char b = s.charAt(i + 1);
            sb.append((char)(SerialClient.hexToInt(a) << 4 | SerialClient.hexToInt(b)));
            i += 2;
        }
        return sb.toString();
    }

    static byte[] hexStringToCharArray(String s) {
        String[] strr = s.split(" ");
        byte[] r = new byte[strr.length];
        int j = 0;
        while (j < strr.length) {
            char a = strr[j].charAt(0);
            char b = strr[j].charAt(1);
            r[j] = (byte)(SerialClient.hexToInt(a) << 4 | SerialClient.hexToInt(b));
            ++j;
        }
        return r;
    }

    public static String getHFCardSerialNumber() {
        String[] rfPacket;
        String cardSerialNumber = "";
        String headerPacket = "aa 00 00";
        String rx = SerialClient.TalkRFID("/dev/" + ConfigPropertiesFile.HFComPort, ConfigPropertiesFile.HFSerielNumCmd, 1000);
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.out.println(rx);
        }
        if ((rfPacket = rx.split("  ?"))[2].equals("02") && rfPacket[3].equals("01")) {
            return null;
        }
        int len = Integer.parseInt(rfPacket[2]);
        int dataLength = rfPacket.length - 2;
        int i = 4;
        while (i < dataLength) {
            cardSerialNumber = String.valueOf(cardSerialNumber) + rfPacket[i];
            ++i;
        }
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.err.println("cardSerialNumber==============" + cardSerialNumber);
        }
        return cardSerialNumber;
    }

    public static String getLFCardSerialNumber() {
        String cardSerialNumber = "";
        String headerPacket = "aa";
        String rx = SerialClient.TalkRFID("/dev/" + ConfigPropertiesFile.LFComPort, ConfigPropertiesFile.LFSerielNumCmd, 1000);
        String[] rfPacket = rx.split("  ?");
        if (rfPacket[2].equals("01") && rfPacket[3].equals("01")) {
            return null;
        }
        int len = Integer.parseInt(rfPacket[2]);
        int dataLength = rfPacket.length - 2;
        int i = 4;
        while (i < dataLength) {
            cardSerialNumber = String.valueOf(cardSerialNumber) + rfPacket[i];
            ++i;
        }
        return cardSerialNumber;
    }

    public static String turnRelaySwitch1_On() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_on, 1000);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_window);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 1);
                if (switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch1 On, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch1 Retry Counter: " + retryCounter);
                }
                status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_on, 1000);
                ++retryCounter;
            }
        } else {
            SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch1_on_linux);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_linux);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 1);
                if (switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch1 On, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch1 Retry Counter: " + retryCounter);
                }
                SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch1_on_linux);
                ++retryCounter;
            }
        }
        return status;
    }

    public static void main(String[] args) {
        SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch1_on_linux);
    }

    public static boolean relaySwitchStatus(String returnData, Integer switchNumber) {
        String[] statusSplit;
        if (ConfigPropertiesFile.DEMO_MODE) {
            returnData = "02 3C 29 33 31 30 03 27";
        }
        if ((statusSplit = returnData.split(" ")).length == 8) {
            String switch1 = statusSplit[4];
            String switch2 = statusSplit[5];
            if (switchNumber == 1) {
                if (switch1.equalsIgnoreCase("30")) {
                    return false;
                }
                if (switch1.equalsIgnoreCase("31")) {
                    return true;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Switch1 Status Not Specified....");
                }
                return false;
            }
            if (switchNumber == 2) {
                if (switch2.equalsIgnoreCase("30")) {
                    return false;
                }
                if (switch2.equalsIgnoreCase("31")) {
                    return true;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Switch2 Status Not Specified....");
                }
                return false;
            }
            if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                System.err.println("Switch Not Determine...............");
            }
            return false;
        }
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.err.println("Wrong returnData Format: " + returnData);
        }
        return false;
    }

    public static String relayStatus(String commandDevice) {
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.out.println("=============================================================Relay Status Method Called...." + commandDevice);
        }
        try {
            StringBuffer sb = new StringBuffer();
            Process p = Runtime.getRuntime().exec("stty -F /dev/" + ConfigPropertiesFile.RelayComPort + " 38400");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                System.out.println("First Command Execute: " + sb.toString());
            }
            p = Runtime.getRuntime().exec("stty -F /dev/" + ConfigPropertiesFile.RelayComPort);
            p.waitFor();
            sb = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                System.out.println(sb.toString());
            }
            commandDevice = commandDevice.replace("x", "\\x");
            System.out.println(commandDevice);
            String[] cmdline = new String[]{"bash", "-c", "echo -e \"" + commandDevice + "\" > /dev/" + ConfigPropertiesFile.RelayComPort};
            System.out.print(cmdline);
            p = Runtime.getRuntime().exec(cmdline);
            p.waitFor();
            sb = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                System.out.println("Relay Device Status -> Command: " + commandDevice + ", Return value: " + sb.toString());
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                e.printStackTrace();
            }
            return "error";
        }
    }

    public static void relayOnLinux(String relaySwitch) {
        block9: {
            System.out.println("===============================Relay on Command executed.......");
            try {
                StringBuffer sb = new StringBuffer();
                Process p = Runtime.getRuntime().exec("stty -F /dev/" + ConfigPropertiesFile.RelayComPort + " 38400");
                p.waitFor();
                BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Return data: " + sb.toString());
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Command stty -F /dev/" + ConfigPropertiesFile.RelayComPort);
                }
                p = Runtime.getRuntime().exec("stty -F /dev/" + ConfigPropertiesFile.RelayComPort);
                p.waitFor();
                sb = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                line = "";
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Return data: " + sb.toString());
                }
                relaySwitch = relaySwitch.replace("x", "\\x");
                System.out.print(relaySwitch);
                String[] cmdline = new String[]{"bash", "-c", "echo -e \"" + relaySwitch + "\" > /dev/" + ConfigPropertiesFile.RelayComPort};
                System.out.print(cmdline);
                p = Runtime.getRuntime().exec(cmdline);
                p.waitFor();
                sb = new StringBuffer();
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                line = "";
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Return Data: " + sb.toString());
                }
                System.out.println("===============================Relay on Command execution Finish.......");
            }
            catch (Exception e) {
                if (!ConfigPropertiesFile.DEBUG_MODE_ON) break block9;
                e.printStackTrace();
            }
        }
    }

    public static void relayOffLinux(String relaySwitch) {
        block2: {
            try {
                Process p = Runtime.getRuntime().exec("stty -F /dev/" + ConfigPropertiesFile.RelayComPort + " 38400");
                p.waitFor();
                relaySwitch = relaySwitch.replace("x", "\\x");
                String[] cmdline = new String[]{"bash", "-c", "echo -e \"" + relaySwitch + "\" > /dev/" + ConfigPropertiesFile.RelayComPort};
                p = Runtime.getRuntime().exec(cmdline);
                p.waitFor();
            }
            catch (Exception e) {
                if (!ConfigPropertiesFile.DEBUG_MODE_ON) break block2;
                e.printStackTrace();
            }
        }
    }

    public static String turnRelaySwitch2_On() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_on, 1000);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_window);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 2);
                if (switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch2 On, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch2 Retry Counter: " + retryCounter);
                }
                status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_on, 1000);
                ++retryCounter;
            }
        } else {
            SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch2_on_linux);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_linux);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 2);
                if (switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch2 On, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch2 Retry Counter: " + retryCounter);
                }
                SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch2_on_linux);
                ++retryCounter;
            }
        }
        return status;
    }

    public static String turnRelaySwitch3_On() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch3_on, 1000);
        } else {
            SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch3_on_linux);
        }
        return status;
    }

    public static String turnRelaySwitch4_On() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch4_on, 1000);
        } else {
            SerialClient.relayOnLinux(ConfigPropertiesFile.RelaySwitch4_on_linux);
        }
        return status;
    }

    public static String turnRelaySwitch1_Off() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                System.out.println("Work Well");
            }
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_off, 1000);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_window);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 1);
                if (!switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch1 off, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch1 Retry Counter: " + retryCounter);
                }
                status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch1_off, 1000);
                ++retryCounter;
            }
        } else {
            SerialClient.relayOffLinux(ConfigPropertiesFile.RelaySwitch1_off_linux);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_linux);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 1);
                if (!switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch1 off, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch1 Retry Counter: " + retryCounter);
                }
                SerialClient.relayOffLinux(ConfigPropertiesFile.RelaySwitch1_off_linux);
                ++retryCounter;
            }
        }
        return status;
    }

    public static String turnRelaySwitch2_Off() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_off, 1000);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_window);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 2);
                if (!switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch2 off, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch2 Retry Counter: " + retryCounter);
                }
                status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch2_off, 1000);
                ++retryCounter;
            }
        } else {
            SerialClient.relayOffLinux(ConfigPropertiesFile.RelaySwitch2_off_linux);
            int retryCounter = 1;
            while (retryCounter < 7) {
                String relayStatus = SerialClient.relayStatus(ConfigPropertiesFile.Relay1_status_linux);
                boolean switchStatus = SerialClient.relaySwitchStatus(relayStatus, 2);
                if (!switchStatus) {
                    if (!ConfigPropertiesFile.DEBUG_MODE_ON) break;
                    System.out.println("Relay Switch2 off, Retry Counter: " + retryCounter);
                    break;
                }
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.err.println("Relay Switch2 Retry Counter: " + retryCounter);
                }
                SerialClient.relayOffLinux(ConfigPropertiesFile.RelaySwitch2_off_linux);
                ++retryCounter;
            }
        }
        return status;
    }

    public static String turnRelaySwitch3_Off() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch3_off, 1000);
        } else {
            SerialClient.relayOffLinux(ConfigPropertiesFile.RelaySwitch3_off_linux);
        }
        return status;
    }

    public static String turnRelaySwitch4_Off() {
        String status = null;
        if (ConfigPropertiesFile.OS_TYPE.equals("Window")) {
            status = SerialClient.TalkRelay(ConfigPropertiesFile.RelayComPort, ConfigPropertiesFile.RelaySwitch4_off, 1000);
        } else {
            SerialClient.relayOffLinux(ConfigPropertiesFile.RelaySwitch4_off_linux);
        }
        return status;
    }

    public static String getCardSerialNumber() {
        if (ConfigPropertiesFile.DEBUG_MODE_ON) {
            System.err.println("m here 1111111111");
        }
        String cardSerialNumber = null;
        try {
            try {
                cardSerialNumber = ConfigPropertiesFile.CARD_TYPE.equals("LF") ? SerialClient.getLFCardSerialNumber() : SerialClient.getHFCardSerialNumber();
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    System.out.println("Card Seriel Number" + cardSerialNumber);
                }
            }
            catch (Exception e) {
                if (ConfigPropertiesFile.DEBUG_MODE_ON) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {}
        return cardSerialNumber;
    }
}

